/***************************************************************

   Copyright 1994  Northeast Data Corp.  All Rights Reserved

****************************************************************/

/***************************************************************


   PhotoV.h

   Public definitions for applications that use the PhotoV
   control.

    - Messages
    - Notification codes.
    - Control Styles.

****************************************************************/

// The one callable function to force the DLL to load
void FAR PASCAL registerPhotoV(void);

//Max and min scale percentages
#define MAXSCALE           400
#define MINSCALE           3.3

//Number of menu characters in the menus property
#define MAXMENUS           14

//Menu items to enable/disable (offsets into the menu property string)
#define MENUCOPY              0
#define MENUBESTFIT           1
#define MENUFITVERT           2
#define MENUFITHORZ           3
#define MENU1TO1              4
#define MENUINCREASECONTRAST  5
#define MENUDECREASECONTRAST  6
#define MENUZOOMIN            7
#define MENUZOOMOUT           8
#define MENUPRINT             9
#define MENUROTATE0           10
#define MENUROTATE90          11
#define MENUROTATE180         12
#define MENUROTATE270         13


//Control specific styles.
#define CS_TABSTOP              0x0080L

//Base for all messages to and from the PhotoV
#define PHOTOV_BASE               WM_USER+2000

  
   //Messages interface for the PhotoV Control
#define ICM_SETFILE           PHOTOV_BASE+1
#define ICM_SETCOMMAND        PHOTOV_BASE+2
#define ICM_SETBACKCOLOR      PHOTOV_BASE+3
#define ICM_SETROTATION       PHOTOV_BASE+4
#define ICM_SETSCALE          PHOTOV_BASE+5
#define ICM_SETSCALEPERCENT   PHOTOV_BASE+6  
#define ICM_SETVSCROLLPOS     PHOTOV_BASE+7
#define ICM_SETHSCROLLPOS     PHOTOV_BASE+8
#define ICM_GETPROPERTY       PHOTOV_BASE+9
#define ICM_SETHDCPRN         PHOTOV_BASE+10
#define ICM_SAVEAS            PHOTOV_BASE+11
#define ICM_SETCOMPRESSION    PHOTOV_BASE+12
#define ICM_SETSHOWRIGHTS     PHOTOV_BASE+13
#define ICM_SETEFFECT         PHOTOV_BASE+14

   // wParam values for the ICM_SETCOMMAND message
#define COMMANDZOOMIN      1
#define COMMANDZOOMOUT     2
#define COMMANDINCREASE    3
#define COMMANDDECREASE    4
#define COMMANDPRINT       5
#define COMMANDCOPY        6
#define COMMANDMAX         6

   // wParam values for the ICM_SETROTATION message
#define ROTATE0      0
#define ROTATE90     1
#define ROTATE180    2
#define ROTATE270    3
#define ROTATEMAX    3

   // wParam values for the ICM_SETSCALE message
#define SCALEFITVERT       0
#define SCALEFITHORZ       1
#define SCALE1TO1          2
#define SCALEBESTFIT       3
#define SCALEPERCENT       4    
#define SCALEMAX           4

   // Enumerated values used in the ICM_GETPROPERTY 
   //   wParam to specify
   //   which property is to be accessed
#define IVAL_ROTATION       1
#define IVAL_SCALE          2
#define IVAL_SCALEPERCENT   3
#define IVAL_FILENAME       4
#define IVAL_BACKCOLOR      5
#define IVAL_VSCROLLPOS     6
#define IVAL_HSCROLLPOS     7
#define IVAL_HDCPRN         8
#define IVAL_COMPRESSION    9
#define IVAL_RIGHTSFILE     10
#define IVAL_MENUS          11
#define IVAL_IMAGEWIDTH     12
#define IVAL_IMAGEHEIGHT    13

   // Notifications
#define ICN_MENUCHANGE      1

   //Error codes
#define VBERR_BASE            30001 // Messages get numbered from here
#define VBERR_FILEOPEN        VBERR_BASE
#define VBERR_COMMANDFAILED   VBERR_BASE+1
#define VBERR_BACKCOLOR       VBERR_BASE+2
#define VBERR_SCROLLBARS      VBERR_BASE+3
#define VBERR_ROTATION        VBERR_BASE+4
#define VBERR_POLARITY        VBERR_BASE+5
#define VBERR_SCALE           VBERR_BASE+6
#define VBERR_SCALEPERCENT    VBERR_BASE+7
#define VBERR_CONTRAST        VBERR_BASE+8
#define VBERR_VSCROLLPOS      VBERR_BASE+9
#define VBERR_HSCROLLPOS      VBERR_BASE+10
#define VBERR_BADMODE         VBERR_BASE+11
#define VBERR_MOREMEM         VBERR_BASE+12
#define VBERR_INVALIDCOMMAND  VBERR_BASE+13
#define VBERR_PROPERTY        VBERR_BASE+14
#define VBERR_SAVEAS          VBERR_BASE+15
#define VBERR_INVALIDTYPE     VBERR_BASE+16
#define VBERR_IO              VBERR_BASE+18
#define VBERR_INVALIDARG      VBERR_BASE+19
#define VBERR_NOCD            VBERR_BASE+20
#define VBERR_USERABORT       VBERR_BASE+21
#define VBERR_PCDWRITE        VBERR_BASE+22
#define VBERR_BADRANGE        VBERR_BASE+23
#define VBERR_DISKFULL        VBERR_BASE+25
#define VBERR_NOSUCHFILE      VBERR_BASE+26
#define VBERR_BADTIFF         VBERR_BASE+27
#define VBERR_BADBITSPERPIXEL VBERR_BASE+28
#define VBERR_BADCOMPRESSION  VBERR_BASE+29
#define VBERR_CREATEFILE      VBERR_BASE+30
#define VBERR_BADFILETYPE     VBERR_BASE+31
#define VBERR_COMPDIB         VBERR_BASE+32
#define VBERR_NOTPIW          VBERR_BASE+33
#define VBERR_BADPCX          VBERR_BASE+34
#define VBERR_BADGIF          VBERR_BASE+35
#define VBERR_PRINTERR        VBERR_BASE+36
#define VBERR_BADTGA          VBERR_BASE+38
#define VBERR_BADBMP          VBERR_BASE+39
#define VBERR_NODATA          VBERR_BASE+40
#define VBERR_TIMEOUT         VBERR_BASE+41
#define VBERR_BADLOCK         VBERR_BASE+42
#define VBERR_PRTBUSY         VBERR_BASE+43
#define VBERR_BADBUF          VBERR_BASE+44
#define VBERR_BADJPG          VBERR_BASE+45
#define VBERR_NONE            VBERR_BASE+46
#define VBERR_UNKNOWN         VBERR_BASE+47



